/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.util.IRayTraceResults;
import noppes.npcs.api.wrapper.EntityWrapper;
import noppes.npcs.api.wrapper.data.DataBlock;

public class RayTraceResults
implements IRayTraceResults {
    public static RayTraceResults EMPTY = new RayTraceResults();
    private final Map<BlockPos, DataBlock> blocks = new HashMap<BlockPos, DataBlock>();
    private List<Entity> entitys = new ArrayList<Entity>();

    public void add(Entity entity, double distance, Vec3d vecStart, Vec3d vecEnd) {
        this.entitys = EntityWrapper.findEntityOnPath(entity, distance, vecStart, vecEnd);
    }

    public void add(World world, BlockPos pos, IBlockState state) {
        if (this.blocks.containsKey(pos)) {
            return;
        }
        this.blocks.put(pos, new DataBlock(world, pos, state));
    }

    @Override
    public IBlock[] getBlocks() {
        ArrayList<IBlock> data = new ArrayList<IBlock>();
        for (DataBlock db : this.blocks.values()) {
            data.add(db.getIBlock());
        }
        return data.toArray(new IBlock[0]);
    }

    @Override
    public IEntity<?>[] getEntitys() {
        ArrayList result = new ArrayList();
        for (Entity e : this.entitys) {
            result.add(Objects.requireNonNull(NpcAPI.Instance()).getIEntity(e));
        }
        return result.toArray(new IEntity[0]);
    }

    @Override
    public void clear() {
        this.blocks.clear();
        this.entitys.clear();
    }

    @Override
    public List<DataBlock> getMCBlocks() {
        return new ArrayList<DataBlock>(this.blocks.values());
    }

    @Override
    public List<Entity> getMCEntitys() {
        return this.entitys;
    }
}

